DECLARE SUB lingua2 ()
DECLARE SUB logo ()
'       SUB examples()
' pgm sc9000 : Interface - Dialogue  PC <--> R9000/GTR8000 - controller
'
'
'      R9000/GTR 8000 ZE software rev. 'AM' 2.30  20.07.87
'      sc300  basis: GTZ4801  'BB'                25.10.88 j.e
'      sc8000                 'BB'                25.10.88 j.e
'      sc9000        GTZ4802  V 1.00              06.04.89 j.e
'                             V 1.10              04.08.89 j.e
'                             V 1.15              29.09.89 j.e
'      sc300 basis:           'BD'                28.02.91 j.e
'      sc9000                 V 1.20              28.02.91 j.e  COLOR, TIMER, CUR1+2, bloc+summa new; without pc-sel
'                rev.
'


main:               'programm starts here
	logo                                              'first screen : logo
	GOSUB lingua                                      'select language
	GOSUB config                                      'PC & interface configuration;

mainr:                                            'preset
	DIM par%(34, 80)                                  'array with parameter & values
	DIM par$(80)                                      'array with comment to parameters and values
	DIM nam$(34)                                      'array with channel names
	DIM parp%(18, 5)                                  'array with parameter page
	DIM sctxt$(28)                                    'array with flag-text for parameter

	GOSUB arrayset                                    'clear array par%( , ); set default numbers
	GOSUB tablec                                      'set table with comment for parameters and values
	GOSUB interfaceset                                'set interface number 1 or 2
	GOSUB registerset                                 'set register with default channel numbers
	GOSUB paraset                                     'set table tabpara

'        GOSUB dataset:                                   'input parameters of all controllers


mainerr:                                          'return label on interface error
	GOSUB keyset                                      'set function-keys  level 1

mainloop:                                         'loop for cyclic display and key-control
	GOSUB fkey1                                       'test function-keys level 1
	GOSUB fkey9                                       'test function-key9 level 1
						'switch level 1 --> level 2
	GOSUB scloop                                      'cyclic dialog on interface bus set

	ON scflgk% GOSUB scline, scarray, parameter, bargraph

	GOTO mainloop                                     'end of loop




config:             'configuration PC-type & interface
      CLS
      LOCATE 12, 1: COLOR 7, 1
      IF (lingu% = 0) THEN
	PRINT "   Schnittstellentyp :   com1   Eingabe '1'"
	PRINT "                         com2   Eingabe '2'"
	PRINT
	PRINT "         Eingabe  :";
      ELSE
	PRINT "      serial port :  com1   type `1`"
	PRINT "                     com2   type `2`"
	PRINT
	PRINT "           input  :";
      END IF
confi4:                             'not active
      LOCATE 15, 29: PRINT "     "
      LOCATE 15, 29: aaa$ = INKEY$
      IF (aaa$ = "") THEN GOTO confi4
      comnr% = VAL(aaa$): PRINT aaa$;
      IF ((comnr% < 1) OR (comnr% > 2)) THEN GOTO confi4
      LOCATE 18, 1
      IF (lingu% = 0) THEN
	PRINT "   letzter verwendeter Regelkreis  ( 32 max)"
	INPUT "         Eingabe  :         ", cmax%
      ELSE
	PRINT "     last used channel (32 max)"
	INPUT "      type number :         ", cmax%
      END IF
      IF (cmax% < 1) THEN cmax% = 1
      IF (cmax% > 32) THEN cmax% = 32
      cmax% = (1 + INT((cmax% - 1) * .25)) * 4
      nrc% = cmax%:                                       'test number of channels

      timstop! = TIMER + 2                                'delay about 2 sec
      WHILE (TIMER <= timstop!)                            'delay for display 3 sec
      WEND
    RETURN



arrayset:           'arrayset - clear array par%) ( , ); set number of channels
   FOR sci0% = 0 TO 32
     FOR sci1% = 0 TO 48
	 par%(sci0%, sci1%) = 0:                          'clear array
     NEXT sci1%
     par%(sci0%, 1) = sci0%:                              'set channel number
   NEXT sci0%
  RETURN



interfaceset:       'set interface number 1 or 2
     CLOSE
     IF comnr% = 2 THEN
	 OPEN "com2:2400,n,8,1,DS" FOR RANDOM AS #1 LEN = 1096
	 scrts% = &H2FC                                             'increased up to factor 8
     ELSE
	 OPEN "com1:2400,n,8,1,DS" FOR RANDOM AS #1 LEN = 1096
	 scrts% = &H3FC
     END IF
     ON ERROR GOTO interr:                                'return-address on interface error
  RETURN



interr:             'reset interface error
     RESUME NEXT
     scflgk% = 0
     losch% = 0
     GOSUB keyset
     aa$ = INKEY$
     KEY ON
     GOTO mainerr


registerset:        'set register with default channel numbers
	scnmin% = 1: scnmax% = nrc%                       'limits for channel numbers
	scakt% = 1                                        'set first channel
	scanreg% = 1                                      'used channel --> Screen
	scctst% = scnmax%                                 'start addr. cyclic data load
	scerrctr% = 0                                     'ctr for errors on transm,receive
 
  RETURN



keyset:             'set function-keys level 1
   KEY OFF                                                'set text

   IF (lingu% = 0) THEN
      KEY 1, "zeile": KEY 2, " feld": KEY 3, "param": KEY 4, "bargr"
      KEY 6, "rd fil": KEY 7, "wr fil": KEY 8, "konfig": KEY 10, "stopp"
   ELSE
      KEY 1, " line": KEY 2, "array": KEY 3, "param": KEY 4, "bargr": KEY 5, " ter"
      KEY 6, "rd fil": KEY 7, "wr fil": KEY 8, "config": KEY 10, "stop"
   END IF
   KEY 5, "": KEY 9, ""
   
   KEY(1) ON: KEY(2) ON: KEY(3) ON: KEY(4) ON             'set keys on/off
   KEY(5) OFF: KEY(6) ON: KEY(7) ON: KEY(8) ON
   KEY(9) OFF: KEY(10) ON
   KEY(11) OFF: KEY(12) OFF: KEY(13) OFF: KEY(14) OFF
   KEY(15) OFF: KEY(16) OFF: KEY(17) OFF: KEY(18) OFF: KEY(19) OFF
   KEY ON
   CLS
  RETURN



fkey1:              'test function-keys level 1
   IF (scflgk% <> 0) THEN                                   'level 2
       KEY(10) OFF
       KEY 10, ""
   ELSE                                                     'level 1
       ON KEY(1) GOSUB scfl1                                '  "line"
       ON KEY(2) GOSUB scfl2                                '  "array"
       ON KEY(3) GOSUB scfl3                                '  "param"
       ON KEY(4) GOSUB scfl4                                '  "bargr"
       ON KEY(6) GOSUB rdfil                                '  "rd fil"
       ON KEY(7) GOSUB wrfil                                '  "wr fil"
       ON KEY(8) GOSUB names                                '  "config"
       ON KEY(10) GOSUB scfl10                              '  "stop"
   END IF
  RETURN



fkey9:              'test function-key9 level 1
   ON KEY(9) GOSUB scfl9                                    '  "break"
fkey9sub:
   IF (scflgk% = 0 AND losch% = 0) THEN                     'level 1 & return to level1
      CLS
      LOCATE 9, 1
      losch% = 1
      IF (lingu% = 0) THEN
	PRINT "                  P r o g r a m m  a u s w  h l e n !!!"
      ELSE
	PRINT "                        S E L E C T  J O B ! ! !"
      END IF
   END IF
  RETURN



scfl1:              'subroutine f-key "line" level 2
     scflgk% = 1                                            'level flag
     scxfl% = 0
     CLS                                                    'clear screen
     KEY OFF
     IF (lingu% = 0) THEN
       KEY 6, " nr +": KEY 7, " nr -": KEY 9, "zurck"
     ELSE
       KEY 6, "chan +": KEY 7, "chan -": KEY 9, "break"
     END IF
     KEY 1, "": KEY 2, "": KEY 3, "": KEY 4, "": KEY 5, "": KEY 8, "": KEY 10, ""
     KEY(1) OFF: KEY(2) OFF: KEY(3) OFF: KEY(4) OFF: KEY(5) OFF
     KEY(6) ON: KEY(7) ON: KEY(8) OFF: KEY(9) ON: KEY(10) OFF
     KEY ON
     RETURN



scfl2:              'subroutine f-key "array" level 2
     scflgk% = 2                                            'level flag
     scxfl% = 0
     CLS                                                    'clear screen
     KEY OFF
     IF (lingu% = 0) THEN
       KEY 6, " nr +": KEY 7, " nr -": KEY 9, "zurck"
     ELSE
       KEY 6, "chan +": KEY 7, "chan -": KEY 9, "break"
     END IF
     KEY 1, "": KEY 2, "": KEY 3, "": KEY 4, "": KEY 5, "": KEY 8, "": KEY 10, ""
     KEY(1) OFF: KEY(2) OFF: KEY(3) OFF: KEY(4) OFF: KEY(5) OFF
     KEY(6) ON: KEY(7) ON: KEY(8) ON: KEY(9) ON: KEY(10) OFF
     KEY ON
   RETURN



scfl3:              'subroutine f-key "param" level 2
     scflgk% = 3
     scxfl% = 0                                             'clear refresh - flag
     scparafl% = 0                                          'set "first time"
     scparapg% = 1
     pa% = 0                                                'set page 1
     can% = 4 * pa% + 1                                     'set first channel on display
     lin% = 6                                               'set cursor first line
     row% = 69                                              'set cursor second row
     CLS                                                    'clear screen
     KEY OFF
     IF (lingu% = 0) THEN
       KEY 5, "s. -->": KEY 6, " nr +": KEY 7, " nr -": KEY 9, "zurck"
     ELSE
       KEY 5, "pg -->": KEY 6, "chan +": KEY 7, "chan -": KEY 9, "break"
     END IF
     KEY 1, "": KEY 2, "": KEY 3, "": KEY 4, "": KEY 8, "": KEY 10, ""
     KEY(1) OFF: KEY(2) OFF: KEY(3) OFF: KEY(4) OFF: KEY(5) ON
     KEY(6) ON: KEY(7) ON: KEY(9) ON: KEY(8) OFF: KEY(10) OFF
     KEY(11) ON: KEY(12) ON: KEY(13) ON: KEY(14) ON         'set cursor keys
     KEY ON
     RETURN



scfl4:              'subroutine f-key "bargr" level 2
     scflgk% = 4
     scbarfl% = 0
     scxfl% = 0                                             'clear refresh - flag
     CLS                                                    'clear screen
     KEY OFF
     IF (lingu% = 0) THEN
       KEY 6, " nr +": KEY 7, " nr -": KEY 9, "zurck"
     ELSE
       KEY 6, "chan +": KEY 7, "chan -": KEY 9, "break"
     END IF
     KEY 1, "": KEY 2, "": KEY 3, "": KEY 4, "": KEY 5, "": KEY 8, "": KEY 10, ""
     KEY(1) OFF: KEY(2) OFF: KEY(3) OFF: KEY(4) OFF: KEY(5) OFF
     KEY(6) ON: KEY(7) ON: KEY(8) OFF: KEY(9) ON: KEY(10) OFF
     KEY ON
     RETURN



scfl9:              'subroutine f-key "break" level 1/2
     scflgk% = 0
     scxfl% = 0
     losch% = 0
     scconfl% = 0                                           'clear flag for exit "config"
     scparlop% = 0                                          'clear flag for exit "param"
     GOSUB keyset                                           'set function-keys level 1
     RETURN



scfl10:             'f-key "stop" & programm stop   level 1
     COLOR 7, 0, 0
     CLS
     scflgk% = 0
     LOCATE 9, 1
     PRINT "              *****************  STOP  ***************** ";
     timstop! = TIMER + 1
     WHILE (TIMER <= timstop!)                            'delay for display 1 sec
     WEND
     CLOSE
     STOP




scloop:             'cyclic dialog on interface bus
		    '      flag in array par%( ,79)
			'job only if time distance between two jobs >= 0.6 sec
			'job 1: test "A" (altern. flag) = changed parameters out on bus, one ch.
			'job 2: test "?" ( ask-flag) = input parameters from bus, one channel
			'job 3: cyclic load = input parameters from bus, one channel
			'job 4: cyclic load = input values from bus, one controller=up to 4 chan.
			'job 5: test "D" (data-flag) = parameters in array par%( , )
			'job 6: test "0" (empty) = parameters not in array par%( , )

    IF (TIMER < timlpp!) THEN GOTO scloop12
    timlpp! = TIMER + .55                                  'delay for cyclic dialog >=0.6 sec
	
    IF ((TIMER > timincw!) AND (par%(1, 27) <> 0)) THEN
	timincw! = TIMER + 4
'          par%(1, 34) = (511 AND (1 + par%(1, 34)))       'test: increment w(1) every >2 sec
'          par%(1, 79) = 65
    END IF

    scin$ = "": scout$ = "": sci8% = 0

    FOR sci78% = 0 TO 8                           'increment & test parameter out reg. next 9 channels
       scopreg% = scopreg% + 1
       IF (scopreg% < scnmin%) THEN scopreg% = scnmin%
       IF (scopreg% > scnmax%) THEN scopreg% = scnmin%

       IF (par%(scopreg%, 79) = 65) THEN GOTO scloop4:      'test: "A"
       IF (par%(scopreg%, 79) = 63) THEN                    'test: "?"
	   scin$ = "": scnreg% = scopreg%: scxfl% = 0
	   GOSUB scip                            'subroutine input parameter(scnreg%)
	   RETURN                                           '  to array par%(scnreg%, ); exit sub
       END IF
    NEXT sci78%
    GOTO scloop6                                            'no "A" or "?" - flag

scloop4:                                         '"A" - flag; changed parameters out
    GOSUB scop                                              'subroutine output parameter from
 RETURN


scloop6:                                         'input values or param., all channels on line
    IF (sccc% < 2) THEN                                     ' 2* input value, 1* input param.
	IF (scnfreg% < scnmin%) THEN scnfreg% = scnmin%: GOTO scloop10
	scnfreg% = scnfreg% + 4                             'increment by 4 & test value input reg.
	IF (scnfreg% > scnmax%) THEN scnfreg% = scnmin%
scloop10:
	GOSUB sciw                              'subroutine input values(scnfreg%)
	sccc% = sccc% + 1                       '  to array par%(scnfreg%, )
    ELSE
	sccc% = 0:                                          ' 1* input param.
	IF (scctst% < scnmin%) THEN scctst% = scnmin%: GOTO scloop11
	scctst% = scctst% + 1                               'increment & test parameter input reg.
	IF (scctst% > scnmax%) THEN scctst% = scnmin%
scloop11:                                                   'test : "D" or "0"
	IF ((par%(scctst%, 79) = 68) OR (par%(scctst%, 79) = 0)) THEN
	    scin$ = "": scnreg% = scctst%
	    GOSUB scip                           'subroutine input param.(scctst%)
	END IF                                   '  to array par%(scnreg%, )
    END IF
scloop12:
  RETURN



dataset:            'input data from interface-bus (scnmin%..scnmax%)
 
  LOCATE 7, 1
  IF (lingu% = 0) THEN
     PRINT "          Parameter aller Gerte am Schnittstellen-bus einlesen"
     PRINT
     PRINT "          Regelkreis :";
  ELSE
     PRINT "          read parameters of all controllers on interface"
     PRINT
     PRINT "          channel No :";
  END IF

  scin$ = "": scnreg% = 1                                   'read first time
  scnregold% = scnreg%
  GOSUB scip                                                ' subroutine input param.(scctst%)
  timstop! = TIMER + .5
  WHILE (TIMER <= timstop!)                                 ' delay for next bloc 0.5 sec
  WEND

  FOR sci6% = 1 TO 3:                                       'try max 3 times: input parameters
     FOR sci7% = 1 TO 32       'or: scmin% TO scnmax%         to array par%( , )
	LOCATE 9, 27                                        '  to array par%(scnreg%, )
	PRINT scnregold%;
	LOCATE 9, 31
	IF (par%(sci7%, 79) <> 68) THEN
	   scin$ = "": scnreg% = sci7%
	   GOSUB scip                                       ' subroutine input param.(scctst%)
	   timstop! = TIMER + .4
	   WHILE (TIMER <= timstop!)                        ' delay for next bloc 0.5 sec
	   WEND
	END IF
	IF (lingu% = 0) THEN
	   IF (par%(scnregold%, 79) = 68) THEN
	      PRINT "     gelesen";
	   ELSE
	      PRINT "  fehlerhaft";
	   END IF
	ELSE
	   IF (par%(scnregold%, 79) = 68) THEN           'test input for success
	      PRINT "   load";
	   ELSE
	      PRINT "  fails";
	   END IF
	END IF
	scnregold% = scnreg%
     NEXT sci7%
  NEXT sci6%
RETURN



sciw:               'inputs values of channel(scnfreg%) from interface-bus
		    ' answer has values of one controller (up to 4 chan)
		    ' address is the first channel in the modul; the sequence
		    ' is constantly the same as typing No keys on pannel

  scnfreg% = 4 * INT(.25 * (scnfreg% - 1)) + 1              'first channel of a controller
'  IF (par%(scnfreg%, 27) <= 0) THEN GOTO sciw4              'test channel allowed ?
  sco$ = STR$(par%(scnfreg%, 1))                            'question for values --> scout$
  scout$ = "R" + RIGHT$("00" + RIGHT$(sco$, LEN(sco$) - 1), 2) + " NF?"

  GOTO scinp
sciw4:
  RETURN




scip:               'input parameters of channel(scnreg%) from interface-bus
		    ' answer has parameters of one channel

    IF (par%(scnreg%, 1) <= 0) THEN GOTO scip4:             'test chan. number set
    scout$ = STR$(par%(scnreg%, 1))
						'question for parameters --> scout$
    scout$ = "R" + RIGHT$("00" + RIGHT$(scout$, LEN(scout$) - 1), 2) + " NT?"

    GOSUB scinp


scip4:
    RETURN




scop:               'output parameter-bloc of channel(scopreg%) to interface
		' answer with the summa of parameter-bloc

	 'LOCATE 10, 1: PRINT "1: scopreg%, W:"; par%(scopreg%, 1); par%(scopreg%, 35)

						'test chan.no in array set
	 IF (par%(scopreg%, 1) <= 0) THEN GOTO scop4

						'test parameters loaded;  e.a. cycle time tc
	 IF (par%(scopreg%, 27) <= 0) THEN GOTO scop4:    'G4 > 0 --> p. set


					'head & channel no --> scout$
	 scout$ = STR$(par%(scopreg%, 1))
	 scout$ = "S " + RIGHT$("00" + RIGHT$(scout$, LEN(scout$) - 1), 2) + "  Q "


scop1:                   'par%(scopreg%,1..34)  --> scout$

					'par%(scopreg%,1..12)  --> scout$

	 FOR sci1% = 0 TO 11                              'change  1* signed integer(1+15 bit) --> 3*ASCII
	    scout$ = scout$ + CHR$(64 + (63 AND (par%(scopreg%, 1 + sci1%))))
	 NEXT sci1%

	 FOR sci1% = 0 TO 21            'par%(scopreg%,13..34)  --> scout$
	    sczw = par%(scopreg%, sci1% + 13)
	    scout$ = scout$ + CHR$(64 + (63 AND (FIX(sczw / 64))))
	    scout$ = scout$ + CHR$(64 + (63 AND INT(sczw)))
	 NEXT sci1%

	 scsum% = 0                                       'calculate summa of 56*ASCII
	 FOR sci1% = 0 TO 55
	     scsum% = scsum% + ASC(MID$(scout$, sci1% + 9, 1))
	 NEXT sci1%
						' summa & end-pattern --> scout$
	 scout$ = scout$ + RIGHT$("0000" + HEX$(scsum%), 4) + "Q"

scop2:
	 GOSUB scinp
	
	 par%(scopreg%, 79) = 63                ' set "?" flag : param. out
scop4:
   RETURN




scinp:               'subroutine COMx dialogue & test, split answer into par%(,); test summa
		 '  error-code in scin$

    GOSUB scsub      'subroutine string scout$ to interface & string scin$ from interface COMx
						'subroutine string scout$ to interface

'    LOCATE 10, 2: PRINT "scip: LEN(scin$), S, Q, Q:";
'    PRINT USING "###"; LEN(scin$); INSTR(1, scin$, "S"); INSTR(1, scin$, "Q"); INSTR(65, scin$, "Q")
'    PRINT "scout$..7, scin$ :": PRINT LEFT$(scout$, 7); "    "; scin$
						'test answ.: length
  
    IF (LEN(scin$) >= 142) THEN scin$ = MID$(scin$, 70, 71): 'answer to long
    IF (LEN(scin$) < 69) THEN GOTO scinp6                    'answer to short for a bloc

						'test answ.: place of testpattern "S","T","Q"
'    scpos1% = INSTR(1, "S", scin$)
'    IF ((scpos1% = 0) OR ((LEN(scin$) - scpos1%) < 69)) THEN GOTO scinp6
'    scin$ = MID$(scin$, scpos1% - 1)

    IF (ASC(LEFT$(scin$, 1)) <> 83) THEN GOTO scinp81
    IF (ASC(MID$(scin$, 69, 1)) <> 81) THEN GOTO scinp81
    IF (ASC(MID$(scin$, 7, 1)) <> 81) THEN GOTO scinp2

						'test answ.: chan.no in answer = chan.no in question
    scin$ = MID$(scin$, 9, 61)                              'cleanup answer

    scsum% = 0                                              'answer string: calculate summa of 56*ASCII
    FOR sci1% = 0 TO 55
	 scsum% = scsum% + ASC(MID$(scin$, sci1% + 1, 1))
    NEXT sci1%
						'test answ.: calculated summa = summa in answer
    IF (RIGHT$("0000" + HEX$(scsum%), 4) <> (MID$(scin$, 57, 4))) THEN GOTO scinp81


scinp1:                    ' input of a paramter-bloc to par%(scnfreg,1..34)

					'parameters scin$ --> array  par%(scnreg%,2..34) without channel no

    FOR sci1% = 1 TO 11                                 'change 1*ASCII --> unsigned char ( 6 bit)
	    par%(scnreg%, sci1% + 1) = (63 AND (ASC(MID$(scin$, sci1% + 1, 1))))
    NEXT sci1%


    FOR sci1% = 0 TO 21                                 'change 2*ASCII --> 12 bit integer
	    sczw2% = 64 * (63 AND (ASC(MID$(scin$, sci1% + sci1% + 13, 1))))
	    par%(scnreg%, sci1% + 13) = sczw2% + (63 AND (ASC(MID$(scin$, sci1% + sci1% + 14, 1))))
    NEXT sci1%
  
    par%(scnreg%, 79) = 68                              'set "D" flag: parameters in array

    GOTO scinp9


scinp2:                    ' input of a values-bloc to par%(scnfreg,35..43)

    IF (ASC(MID$(scin$, 7, 1)) <> 83) THEN GOTO scinp6

    scin$ = MID$(scin$, 9, 61)                       'cleanup answer
    scsum% = 0                                       'answer string: calculate summa of 56*ASCII
    FOR sci1% = 0 TO 55
	scsum% = scsum% + ASC(MID$(scin$, sci1% + 1, 1))
    NEXT sci1%

						'test answ.: calculated summa = summa in answer
    IF (RIGHT$("0000" + HEX$(scsum%), 4) <> (MID$(scin$, 57, 4))) THEN GOTO scinp82

					'values scin$ --> array  par%(scnfreg%...scnfreg%+3,35..43)
					'answer has values of up to 4 channels

    FOR sci1% = 0 TO 3                               ' first to fourth channel
	IF (par%(scnfreg% + sci1%, 27) <= 0) THEN GOTO scinp3    'no parameters in array

	  FOR sci2% = 0 TO 3                           'change 2*ASCII --> 12 bit integer
	      asv$ = MID$(scin$, 14 * sci1% + sci2% + sci2% + 1, 2)
	      sczw2% = 64 * (63 AND (ASC(LEFT$(asv$, 1))))
	      par%(scnfreg% + sci1%, sci2% + 35) = sczw2% + (63 AND (ASC(RIGHT$(asv$, 1))))
	  NEXT sci2%
	  
	  FOR sci2% = 0 TO 2
	      par%(scnfreg% + sci1%, sci2% + 39) = (63 AND (ASC(MID$(scin$, 14 * sci1% + sci2% + 9, 1))))
	  NEXT sci2%


	  asv$ = MID$(scin$, 14 * sci1% + 12, 2)
	  sczw2% = 64 * (63 AND (ASC(LEFT$(asv$, 1))))
	  par%(scnfreg% + sci1%, 42) = sczw2% + (63 AND (ASC(RIGHT$(asv$, 1))))
     
	  par%(scnfreg% + sci1%, 43) = (63 AND (ASC(MID$(scin$, 14 * sci1% + 14, 1))))
scinp3:
    NEXT sci1%                          'values are different for each channel
			   
    GOTO scinp9

scinp6:                    ' test received summa after a transmitted param.-bloc

    IF (LEN(scin$) < 5) THEN GOTO scinp85                  'answer to short for a summa
   
    IF (ASC(MID$(scin$, 5, 1)) <> 81) THEN GOTO scinp84    'no "Q" - limiter
    IF (MID$(scout$, 65, 4) <> LEFT$(scin$, 4)) THEN GOTO scinp83  'test summa

    scin$ = "1234567890123456789012345678901234567890123456789012345678901"
						 'answer with 61*ASCII for test
    GOTO scinp9

scinp81:  
    scerre$ = " 1"     'parameter-bloc answer not usable, error code print
    GOTO scinp89                                      ' in "F2=scarray"
scinp82:
    scerre$ = " 2"     'value-bloc answer not usable,      "
    GOTO scinp89
scinp83:   
    scerre$ = " 3"     'summa-answer not usable,           "
    GOTO scinp89
scinp84:   
    scerre$ = " 4"     'answer with wrong or no limiter,   "
    GOTO scinp89
scinp85:     
    scerre$ = " 5"     'answer to short,                   "
    GOTO scinp89

scinp89:                                             'cummulate last 9 error codes
    scerrs$ = RIGHT$("                      " + scerrs$ + scerre$, 18)
    scerrtim$ = TIME$                                'last error
    scerrctr% = scerrctr% + 1                        'increment dialogue error counter

scinp9:                          'print in scarray only !!
  RETURN




scsub:              'subroutine scin$ receive, scout$ transmit, wait maxtimsc
    sclocin% = LOC(1)
    scoutl% = LEN(scout$)
    IF (sclocin% > 0) THEN scin$ = INPUT$(sclocin%, #1)
    OUT scrts%, INP(scrts%) OR 2                            'only on HDX, control with rts
    PRINT #1, scout$
    scsvo2$ = scsvo$: scsvo$ = scout$: scout$ = scsvo2$     'exchange scout$ with scsvo$
    scsvo2% = scsvn%: scsvn% = scnreg%: scnreg% = scsvo2%   'exchange scnreg% with scsvn%
    scsvo2% = scsvf%: scsvf% = scnfreg%: scnfreg% = scsvo2% 'exchange scnfreg% with scsvf%

    maxtimsc! = TIMER + .1                                  'set maxtimsc for ?transmit
    IF (scoutl% > 9) THEN
	maxtimsc! = maxtimsc! + .22                       'set maxtimsc for bloctransmit
    END IF
scsub4:
    scloc% = LOC(1)                                         'input LOC(1)*ASCII, decr. wait maxtimsc
    IF (TIMER >= maxtimsc!) THEN   'test: end of output scout$: clr rts
      OUT scrts%, INP(scrts%) AND &HFD                      'only on HDX, control with RTS
    ELSE
      GOTO scsub4
    END IF

'     LOCATE 6, 1: PRINT "scout$ "; scout$;                 'test output --> bus
'     LOCATE 11, 1: PRINT "scin$  "; LEN(scin$); scin$;     'test input <--  bus
scsub6:
  RETURN




scline:             'display parameters and values for next 6 channels
		    ' make your own version by setting sc22% and calling sctabb
       LOCATE 1, 2                                          'change number of controller
       scrnd% = 2                                           'delta for incr/decr page
       ON KEY(6) GOSUB scanzinc                             '  "chan +"
       ON KEY(7) GOSUB scanzdec                             '  "chan -"
						  'test: data in par%
       GOSUB chanerr

       IF (scxfl% = 0) THEN scxfl% = 1
       LOCATE 3, 2
       sc22% = 1                                  'print channel numbers
       GOSUB sctabb                               'print line with par%-number, comment, 6 * param.
						  'line no = scanreg%; comment = par$(sc22%);
						  'param. are par%(scanreg...scanreg%+5,%sc22%)
       COLOR 7, 1
       PRINT " ------------------------------------------------------------------------------"
       PRINT "                                   "

       sc22% = 35                                 ' print process values
       GOSUB sctabb
       sc22% = 34                                 ' print active setpoint
       GOSUB sctabb
       sc22% = 32                                 ' print alarm low
       GOSUB sctabb
       sc22% = 33                                 ' print alarm high
       GOSUB sctabb
       PRINT "                                   "
       PRINT "                                   "
       FOR sc22% = 13 TO 17
	GOSUB sctabb                              ' print process parameter
       NEXT sc22%
       sc22% = 27                                 ' print cycle time
       GOSUB sctabb
       PRINT "                                   "
       sc22% = 5
       GOSUB sctabb                              ' outputs on ?
sclend:
   RETURN



sctabb:             '  subroutine print array for 6 channels  =f(sc22%)
	COLOR 7, 1
	sc29% = CSRLIN                                    'ask for line number
	PRINT sc22%;                                      'print line number
	LOCATE sc29%, 5
	COLOR 10, 1
	PRINT par$(sc22%);                                'print comment
	COLOR 7, 1
	LOCATE sc29%, 36
	PRINT "";
	FOR sc23% = 0 TO 5                                'print 6 * parameter or value
	   PRINT USING "#######"; par%(sc23% + scanreg%, sc22%);
	NEXT sc23%
	PRINT
  RETURN




scarray:            ' display all parameters and values for one controller

	LOCATE 1, 2
	scparlop% = 1                                       'set param loop
	scrnd% = 4                                          'delta for incr/decr page
	ON KEY(6) GOSUB scanzinc                            '  "chan +"
	ON KEY(7) GOSUB scanzdec                            '  "chan -"

	scaanreg% = 4 * INT(.25 * (scanreg% - 1)) + 1       ' first channel of one controller
	IF (TIMER > scparatim! + 8) THEN
	   scparatim! = TIMER: scxfl% = 0                   ' refresh parameters
	END IF
	IF (scxfl% <> 0) THEN GOTO scarr2
	scxfl% = 1

	COLOR 10, 1
	LOCATE 1, 1
	PRINT "   No    *   K0   K1   K2   K3   K4   K5   K6   K7   K8   K9          ";
	COLOR 7, 1
	LOCATE 2, 1
	FOR sci49% = 0 TO 3
	  PRINT "   "; : PRINT USING "##"; par%(scaanreg% + sci49%, 1); : PRINT "  ";
	  PRINT USING "##"; par%(scaanreg% + sci49%, 2);
	  FOR sci48% = 3 TO 12
	     PRINT USING "#####"; par%(scaanreg% + sci49%, sci48%);
	  NEXT sci48%
	  PRINT
	NEXT sci49%

	PRINT "      "
	PRINT "      ";
	COLOR 10, 1
	PRINT "      H0   H1   H2   H3   H4   H5   H6   H7   H8   H9          "
	COLOR 7, 1
	FOR sci49% = 0 TO 3
	   PRINT "         ";
	   FOR sci48% = 13 TO 22
	     PRINT USING "#####"; par%(scaanreg% + sci49%, sci48%);
	   NEXT sci48%
	   PRINT
	NEXT sci49%

	PRINT "      "
	PRINT "      ";
	COLOR 10, 1
	PRINT "      G0   G1   G2   G3   G4   G5   G6   G7   G8   L-   L+   W "
	COLOR 7, 1
	FOR sci49% = 0 TO 3
	   PRINT "         ";
	   FOR sci48% = 23 TO 34
	     PRINT USING "#####"; par%(scaanreg% + sci49%, sci48%);
	   NEXT sci48%
	   PRINT
	NEXT sci49%

	IF (lingu% = 0) THEN
	   arrasc1$ = " Werte": arrasc2$ = "Parameter ndern:"
	ELSE
	   arrasc1$ = "values": arrasc2$ = "change parameter:"
	END IF
	PRINT "      "
	COLOR 10, 1
	PRINT arrasc1$;
	COLOR 7, 1
	PRINT "";
	COLOR 10, 1
	PRINT "       X   E8    Y   E0   E2   E3   E4   E5   E7 stat";
	LOCATE 19, 62:  PRINT arrasc2$;
	COLOR 7, 1
	LOCATE 18, 61: PRINT "ͻ";
	LOCATE 19, 61: PRINT ""; : LOCATE 19, 79: PRINT "";
	LOCATE 20, 61: PRINT "                 ";
	LOCATE 21, 61: PRINT "                 ";
	LOCATE 22, 61: PRINT "                 ";
	LOCATE 23, 61: PRINT "                 ";
	LOCATE 24, 61: PRINT "ͼ";
	IF (lingu% = 0) THEN
	   LOCATE 20, 62:  PRINT " Rxx     Regelkr "; : ' 01..32
	   LOCATE 21, 62:  PRINT "  xx     Param.  ";
	   LOCATE 22, 62:  PRINT "  xxxx   Wert    "; : ' Kx: 0..15, other 0..4095
	   LOCATE 23, 62:  PRINT "Ta.0-9,K,H,G,<CR>"; : ' K0..9,H0..9,G0..8,W ,L+,L-
	ELSE
	   LOCATE 20, 62:  PRINT " Rxx     channel ";
	   LOCATE 21, 62:  PRINT "  xx     param.  ";
	   LOCATE 22, 62:  PRINT "  xxxx   value   ";
	   LOCATE 23, 62:  PRINT "use 0-9,K,H,G<CR>";
	END IF
	scaft% = 0: scafp% = 0: scqst$ = ""
scarr2:                                 ' reentry for cyclic refresh
	COLOR 7, 1
	LOCATE 20, 1
	FOR sci59% = 0 TO 3
	   PRINT "          ";
	   arrasc1$ = STR$(par%(scaanreg% + sci59%, 35))
	   PRINT RIGHT$("0000" + RIGHT$(arrasc1$, LEN(arrasc1$) - 1), 4); " ";
	   arrasc1$ = STR$(par%(scaanreg% + sci59%, 36))
	   PRINT RIGHT$("0000" + RIGHT$(arrasc1$, LEN(arrasc1$) - 1), 4); " ";
	   FOR sci58% = 37 TO 43
	      PRINT RIGHT$("0000" + HEX$(par%(scaanreg% + sci59%, sci58%)), 4); " ";
	   NEXT sci58%
	   PRINT STR$(par%(scaanreg% + sci59%, 79)); " "
	NEXT sci59%

scarr3:                                 ' parameter input

	IF ((scaft% = 0) AND (scafp% = 0)) THEN scai$ = "00"

	scaim$ = INKEY$
	IF (scaim$ = "") THEN GOTO scarr6
	scaim$ = LEFT$(scaim$, 1)

	IF ((scafp% = 0) OR (scafp% = 1)) THEN
	   IF ((scaim$ >= "0") AND (scaim$ <= "9")) THEN
	      scai$ = RIGHT$(scai$ + scaim$, 2): scaft% = 1
	      GOTO scarr5
	   END IF
	END IF
	IF (scafp% = 1) THEN
	   IF ((scaim$ = "K") OR (scaim$ = "k")) THEN
	       scaim$ = CHR$((79) AND (ASC(scaim$)))
	       scai$ = RIGHT$(scai$ + scaim$, 2): scaft% = 1
	       GOTO scarr5
	   ELSEIF ((scaim$ = "H") OR (scaim$ = "h")) THEN
	       scaim$ = CHR$((79) AND (ASC(scaim$)))
	       scai$ = RIGHT$(scai$ + scaim$, 2): scaft% = 1
	       GOTO scarr5
	   ELSEIF ((scaim$ = "G") OR (scaim$ = "g")) THEN
	       scaim$ = CHR$((79) AND (ASC(scaim$)))
	       scai$ = RIGHT$(scai$ + scaim$, 2): scaft% = 1
	       GOTO scarr5
	   ELSEIF ((scaim$ = "L") OR (scaim$ = "l")) THEN
	       scai$ = RIGHT$(scai$ + scaim$, 2): scaft% = 1
	       GOTO scarr5
	   ELSEIF ((scaim$ = "W") OR (scaim$ = "w")) THEN
	       scaim$ = CHR$((95) AND (ASC(scaim$)))
	       scai$ = RIGHT$(scai$ + scaim$, 2): scaft% = 1
	       GOTO scarr5
	   ELSEIF ((scaim$ = "P") OR (scaim$ = "p")) THEN
	       scaim$ = CHR$((95) AND (ASC(scaim$)))
	       scai$ = RIGHT$(scai$ + scaim$, 2): scaft% = 1
	       GOTO scarr5
	   ELSEIF ((scaim$ = "-") OR (scaim$ = "+")) THEN
	       scai$ = RIGHT$(scai$ + scaim$, 2): scaft% = 1
	       GOTO scarr5
	   ELSEIF ((scaim$ = " ") OR (scaim$ = "+")) THEN
	       scai$ = RIGHT$(scai$ + scaim$, 2): scaft% = 1
	       GOTO scarr5
	   END IF
	END IF
	IF (scafp% = 2) THEN
	   IF ((scaim$ >= "0") AND (scaim$ <= "9")) THEN
	      scai$ = RIGHT$(scai$ + scaim$, 4)
	      scaft% = 1: GOTO scarr5
	   END IF
	END IF
	IF ((scaim$ = CHR$(13)) AND (scafp% >= 2)) THEN
	   scqval% = VAL(scai$)
	   IF ((scqval% < 1) OR (scqval% > 4095)) THEN
	      scai$ = "00"
	   ELSE scafp% = 2: scaft% = 0
	   END IF
	   par%(scqno%, scqpar%) = VAL(scai$)      ' CHANGE PARAMETER !!
	   par%(scqno%, 79) = 65                   ' set flag "changed parameters"
	   scxfl% = 0
	   'LOCATE 12,8:PRINT"scarr2: scnreg`,scai$,scqst$,scout$";scnreg%;scai$;scqst$;scout$;"       ";
	   scparatim! = TIMER
	   scafp% = 0: scqst$ = "": scaft% = 0
	END IF
	IF (scaim$ = CHR$(13)) THEN
	    IF (scafp% = 1) THEN                   'look for letter pair in par$()
	       scai$ = RIGHT$("  " + scai$, 2)
	       FOR sci28% = 3 TO 34
		 IF (scai$ = MID$(par$(sci28%), 25, 2)) THEN
		     scqpar% = sci28%
		     scafp% = 2: scaft% = 0
		     GOTO scarr4
		 END IF
	       NEXT sci28%
	       scai$ = "  "
	       scqpar% = 78
scarr4:
	    ELSEIF (scafp% = 0) THEN
	       scqno% = VAL(scai$)
	       IF ((scqno% < 1) OR (scqno% > 32)) THEN
		scai$ = "00"
	       ELSE scafp% = 1: scaft% = 0
	       END IF
	    END IF
	    scparatim! = TIMER
	END IF
	IF ((scaft% = 0) AND (scafp% = 0)) THEN scai$ = "00": GOTO scarr5
	IF ((scaft% = 0) AND (scafp% = 2)) THEN scai$ = "0000": GOTO scarr5
	IF ((scaft% = 0) AND (scafp% = 1)) THEN scai$ = "  ": GOTO scarr5

	GOTO scarr6
scarr5:
	COLOR 8, 7: LOCATE 20 + scafp%, 64: PRINT scai$; : COLOR 7, 1
	scparatim! = TIMER

scarr6:
	LOCATE 18, 38: PRINT LEFT$(scout$, 7); "          "; 'test: show question,length of answer
	LOCATE 18, 48: PRINT LEN(scin$); "    ";
	' LOCATE 12, 8: PRINT scin$: PRINT LEN(scin$); 'test: show answer
	' LOCATE 6,8:PRINT "scarr6: scaft,scafp,scai$,scqst$,scout$";scaft%;scafp%;scai$;scqst$;scout$;       ";

'          LOCATE 24, 2: PRINT "interface error code:"; scerrs$; "- "; scerrtim$; " :"; scerrctr%;

scarr9:
    RETURN



scanzinc:           ' subroutine f-key "pg up" level 2, increments by scrnd% channels
    scxfl% = 0
    scbarfl% = 0
    scparafl% = 0
    IF (scanreg% < scnmax% - scrnd% + 1) THEN               ' test max number of channels
	scanreg% = scanreg% + scrnd%
    ELSE
	scanreg% = scnmin%
    END IF
    GOSUB scanzsub
  RETURN



scanzdec:           ' subroutine f-key "pg dwn" level 2, decrements by scrnd% channels
    scxfl% = 0
    scbarfl% = 0
    scparafl% = 0
    IF (scanreg% > scrnd%) THEN                             ' test min number of channels
	scanreg% = scanreg% - scrnd%
    ELSE
	scanreg% = scnmax% - scrnd% + 1
    END IF
    GOSUB scanzsub
  RETURN



scanzsub:           '  subroutine for scanzinc,-dec set can%
    IF (scparapg% >= 1) THEN lin% = 6: row% = 39
    can% = 4 * INT(.25 * (scanreg% - 1)) + 1                ' calculate first channel
  RETURN
 


chanerr:            ' test parameter not in array
       COLOR 15, 1
       cerr% = 0                                                      'test channel 1
       IF (par%(scanreg%, 27) < 1) THEN cerr% = 1
       IF (par%(scanreg% + 1, 27) < 1) THEN cerr% = 1
       IF (par%(scanreg% + 2, 27) < 1) THEN cerr% = 1
       IF (par%(scanreg% + 3, 27) < 1) THEN cerr% = 1
       IF (cerr% = 1) THEN
	  IF (lingu% = 0) THEN
	     PRINT " **********  Datenuebertragung nicht abgeschlossen oder gestoert  ***********";
	  ELSE
	     PRINT " **********  data transmission incomplete or incorrect  ****************";
	  END IF
       ELSE
	 PRINT SPC(78);
       END IF
       COLOR 7, 1
   RETURN



parameter:          'display parameters & values for 4 channels
		    ' change parameters
		    'subroutine f-key "param" level 1
	LOCATE 1, 1
	scrnd% = 4                                          'delta for incr/decr page
	CLS                                                 'first time clear screen
	scparlop% = 1
	scparapg% = 2
	GOSUB scpaginc                                      'set flags line,row,channel
	can% = 4 * INT(.25 * (scanreg% - 1)) + 1            ' calculate first channel of two controllers
	COLOR 7, 1
	ON KEY(5) GOSUB scpaginc                            '  "pg -->"
	ON KEY(6) GOSUB scanzinc                            '  "chan +"
	ON KEY(7) GOSUB scanzdec                            '  "chan -"
	ON KEY(11) GOSUB curup                              'cursor up
	ON KEY(12) GOSUB curleft                            'cursor left
	ON KEY(13) GOSUB curight                            'cursor right
	ON KEY(14) GOSUB curdwn                             'cursor down

para1:
     inpu$ = ""
para2:                                            'lop until fkt ta "break"
     LOCATE lin%, row%
     inn$ = INKEY$                                'change ?
     IF (scparafl% = 0) THEN                      'refresh display new or refresh
	scansv% = can%
	ON (scparapg%) GOSUB chanpar, syspar      'page incr. or chan change: new page
	scparafl% = 1: scparatim! = TIMER         'reset refresh counter
	GOSUB curset
     ELSE
	 IF (TIMER > scparatim! + 8) THEN
	     scparafl% = 0                        ' refresh depentend of PC type
	     LOCATE 2, 72
	     PRINT LEFT$(TIME$, 5);
	     LOCATE 1, 2
	     GOSUB chanerr                        ' set first "channel without parameters"
	     LOCATE lin%, row%
	     inpu$ = "": inpu% = 0
	 END IF
     END IF

     IF (inn$ = "") THEN GOTO para5                         'wait

     IF ((LEN(inn$) = 2) AND (ASC(LEFT$(inn$, 1)) = 0)) THEN
	inn$ = RIGHT$(inn$, 1)                               'check first cursor bloc
	IF (inn$ = "H") THEN
	   GOSUB curup                                       'cursor up
	ELSEIF (inn$ = "K") THEN GOSUB curleft               'cursor left
	ELSEIF (inn$ = "M") THEN GOSUB curight               'cursor right
	ELSEIF (inn$ = "P") THEN GOSUB curdwn                'cursor down
	END IF
	inn$ = ""                                            'clr input buffer
	GOSUB curset                                         'set value, wait
	scparatim! = TIMER
	GOTO para5
     END IF

para3:
     IF (inn$ <> CHR$(13)) THEN                             'input
	COLOR 8, 7
	IF ((scparapg% = 1) AND (lin% >= 17)) THEN          ' page 1: incr flag register from min to max
	   scflgsv% = scflgsv% + 1
	   IF (scflgsv% > parp%(lin% - 5, 3)) THEN scflgsv% = parp%(lin% - 5, 5)
	   inpu$ = sctxt$(parp%(lin% - 5, 4) + scflgsv%)
	ELSEIF (scparapg% >= 2) THEN                        ' page 2: incr flag register from min to max
	   scflgsv% = (1 AND (scflgsv% + 1))                ' only 0 or 1
	   scss4% = can%
	   GOSUB curpg2                                     ' calculate offset
	   inpu$ = sctxt$(scss2% + scflgsv%)                ' offset + flag
	ELSE
	   inpu$ = inpu$ + inn$                             ' page 1: input parameters
	END IF

	LOCATE lin%, row%                                   'display input
	PRINT RIGHT$("         " + inpu$, 8);
	COLOR 7, 1
	GOTO para2
     ELSE                                                   ' <CR>: end of input
	IF (inpu$ = "") THEN GOSUB curdwn: GOTO para5       'cursor down without change
	inpu% = VAL(inpu$)
	IF (((scparapg% = 1) AND (lin% >= 17)) OR (scparapg% = 2)) THEN
	   inpu% = scflgsv%                                 'flag input
	ELSE                                                'parameter input
	   IF (inpu% < parp%(lin% - 5, 5)) THEN inpu% = parp%(lin% - 5, 5) 'test lower limit
	   IF (inpu% > parp%(lin% - 5, 3)) THEN inpu% = parp%(lin% - 5, 3) 'test higher limit
	END IF
	GOSUB curcalc                                       'calculate padr%
	IF (par%(can%, 27) > 0) THEN
	   IF (scparapg% = 1) THEN                      'page 1
	      IF ((lin% = 18) OR (lin% = 19)) THEN                      'K5,K6 &,or 8
		 par%(can%, padr%) = par%(can%, padr%) AND &H37    'correct exceptions
		 IF (inpu% <> 0) THEN par%(can%, padr%) = par%(can%, padr%) OR 8
		 GOTO para4
	      ELSEIF ((lin% = 20) AND (inpu% = 8)) THEN inpu% = 15      'K3, K2 = 0..2
	      ELSEIF ((lin% = 20) AND (inpu% > 5)) THEN inpu% = inpu% + 4
	      END IF
	   ELSEIF (scparapg% >= 2) THEN                     'page 2
	      IF (lin% = 6) THEN
		 par%(can%, 3) = ((par%(can%, 3) AND &H3E) OR inpu%)
	      ELSEIF (lin% = 7) THEN par%(can%, 3) = ((par%(can%, 3) AND &H3D) OR (inpu% + inpu%))
	      ELSEIF (lin% = 8) THEN par%(can%, 8) = ((par%(can%, 8) AND &H3D) OR (inpu% + inpu%))
	      ELSEIF (lin% = 9) THEN par%(can%, 8) = ((par%(can%, 8) AND &H3E) OR inpu%)
	      ELSEIF (lin% = 10) THEN par%(can%, 10) = ((par%(can%, 10) AND &H37) OR (8 * inpu%))
	      ELSE GOTO para5
	      END IF
	      GOTO para4:
	   END IF
	   par%(can%, padr%) = inpu%                        'change parameter
para4:
	   par%(can%, 79) = 65                              'set "A" - flag
	END IF
	GOSUB curset                                        'display input, calculate padr%
	GOSUB curclr                                        'display off
	timstop! = TIMER + .1
	WHILE (TIMER <= timstop!)                           'delay for display clear 0.1 sec
	WEND
	GOSUB curdwn
	inpu$ = "": inpu% = 0
     END IF
para5:
     GOSUB scloop                                 'cyclic dialog on interface bus set
     IF (scparlop% <> 0) THEN GOTO para2                    ' loop until fkt9 key
     CLS
     scflgk% = 0                                            'level 2-->1
     scxfl% = 0                                             'clear refresh - flag
     scparafl% = 0                                          'clear flg first time
     scparapg% = 0                                          'flg,page for "param"
     COLOR 7, 1                                             'reset color
     GOSUB keyset                                           'set fkeys level 1
   RETURN



chanpar:            ' display parameters
	scansv% = can%
	GOSUB header
       
	dimen$ = "%."                                        'default  "%"
	dimms$ = dimen$                                       ' save dimension
       
	scdiff = 1
	FOR sc28% = 1 TO 7
	    GOSUB scpart
	NEXT sc28%
       
	dimen$ = "s"
	FOR sc28% = 8 TO 10
	    GOSUB scpart
	NEXT sc28%
       
	dimen$ = " "
	FOR sc28% = 12 TO 15                                'set channel mode
	    GOSUB scpop                                     'set direction output
	NEXT sc28%                                          'set limit comparator
							    'set self tuning
	sc28% = 17
	GOSUB scpart                                        'set data flag
	LOCATE 23, 2: PRINT SPC(77);
	can% = scansv%
  RETURN

syspar:             ' display parameters & values
	scansv% = can%
	GOSUB header
       
	dimen$ = " "
	COLOR 7, 1
	FOR sc28% = 1 TO 5                                  'set channel mode
	    GOSUB scpop                                     'set direction output
	NEXT sc28%                                          'set limit comparator
       
	LOCATE 13, 34
	FOR sc23% = 0 TO 3                                  'print 4 * parameter or value text
	    PRINT "    ";
	    PRINT USING "######"; par%(can% + sc23%, 35);
	NEXT sc23%
	PRINT " %.";
       
	dimen$ = " "
	COLOR 7, 1
	FOR sc23% = 0 TO 3
	   scsv3% = (par%(can% + sc23%, 41) AND 63)
	   LOCATE 16, 37 + sc23% * 10                              ' SP 1
	   IF (scsv3% AND 2) THEN scsv4% = 3 ELSE scsv4% = 2
	   PRINT RIGHT$("          " + sctxt$(scsv4%), 10);
	   LOCATE 17, 37 + sc23% * 10                              ' SP 2
	   IF (scsv3% AND 1) THEN scsv4% = 3 ELSE scsv4% = 2
	   PRINT RIGHT$("          " + sctxt$(scsv4%), 10);
	   LOCATE 18, 37 + sc23% * 10                              ' L-
	   IF (scsv3% AND 8) THEN scsv4% = 19 ELSE scsv4% = 18
	   PRINT RIGHT$("          " + sctxt$(scsv4%), 10);
	   LOCATE 19, 37 + sc23% * 10                              ' L+
	   IF (scsv3% AND 4) THEN scsv4% = 19 ELSE scsv4% = 18
	   PRINT RIGHT$("          " + sctxt$(scsv4%), 10);
	   scsv3% = (par%(can% + sc23%, 40) AND 63)
	   LOCATE 21, 37 + sc23% * 10                              ' sensor error
	   IF (scsv3% AND 8) THEN scsv4% = 19 ELSE scsv4% = 18
	   PRINT RIGHT$("          " + sctxt$(scsv4%), 10);
	NEXT sc23%

	scsv3% = 18 + (1 AND scsv3%)                 ' cold junction error
	LOCATE 22, 55: PRINT RIGHT$("          " + sctxt$(scsv3%), 8);
	COLOR 7, 1
	can% = scansv%
   RETURN


header:             ' subr set header
	LOCATE 2, 2
	datum$ = DATE$
	can% = 4 * INT(.25 * (scanreg% - 1)) + 1          ' calculate first channel
       
	IF (lingu% = 0) THEN
	   scpa$ = "Regelmodul # ": scpb$ = "Regelkreis Name": scpc$ = "           Nummer"
	   datum$ = MID$(datum$, 4, 2) + "." + LEFT$(datum$, 2) + "." + RIGHT$(datum$, 4)
	ELSE
	   scpa$ = "controller modul # ": scpb$ = "name of channel": scpc$ = "number of channel"
	END IF

	LOCATE 2, 2: PRINT scpa$; INT(.25 * (can% - 1)) + 1
	LOCATE 2, 55: PRINT datum$
	LOCATE 3, 2: PRINT scpb$;
	LOCATE 4, 2: PRINT scpc$;
	FOR sc41% = 0 TO 3
	  LOCATE 3, 39 + 10 * sc41%
	  PRINT RIGHT$("          " + nam$(can% + sc41%), 8);
	  LOCATE 4, 43 + 10 * sc41%
	  PRINT USING "####"; par%(can% + sc41%, 1);
	NEXT sc41%
	PRINT " -----------------------------------------------------------------------------"
	COLOR 10, 1
	IF (scparapg% = 1) THEN                   'parameters
	   FOR sc41% = 1 TO 17                    'set text lines
	      LOCATE sc41% + 5, 2
	      IF (parp%(sc41%, 1) = 0) THEN       'empty line
		 PRINT SPC(78);
	      ELSE                                'text
		 PRINT par$(parp%(sc41%, 1));
	      END IF
	   NEXT sc41%
	ELSE                                      'values
						  'set text lines
	   scpa$ = "autotune                K0"
	   scpb$ = "protocoll line          K0"
	   scpc$ = "setpoint exchange       K5"
	   scpd$ = "alarm delay             K5": scpe$ = "process value"
	   IF (lingu% = 0) THEN
	      scpa$ = "Optimierung             K0"
	      scpb$ = "Protokollzeile          K0 ": scpe$ = "Regelgrsse"
	      scpc$ = "Sollwert Tausch         K5"
	      scpd$ = "Grenzkontakt Delay      K5"
	   END IF
	      LOCATE 6, 2: PRINT scpa$
	      LOCATE 7, 2: PRINT scpb$
	      LOCATE 8, 2: PRINT scpc$
	      LOCATE 9, 2: PRINT scpd$
	      LOCATE 10, 2: PRINT scpe$
	      PRINT SPC(78); " "                   'empty line
	      PRINT SPC(78); " "                   'empty line
	      LOCATE 13, 2
	      PRINT par$(35)
	      PRINT SPC(78); " "                   'empty line
	      PRINT SPC(78); " "                   'empty line
	  
	   scpa$ = "output               ": scpb$ = "high"
	   scpc$ = " low": scpd$ = "sensor": scpe$ = "cold junction"
	   IF (lingu% = 0) THEN
	      scpa$ = "Ausgang              ": scpb$ = " max"
	      scpc$ = " min": scpd$ = "Fhler": scpe$ = "Vergleichsstelle"
	      LOCATE 18, 2: PRINT "Alarm                "; scpc$;
	   ELSE
	      LOCATE 18, 2: PRINT "alarm                "; scpc$;
	   END IF
	   LOCATE 16, 2: PRINT scpa$; "   I"
	   LOCATE 17, 23: PRINT "  II";
	   LOCATE 19, 23: PRINT scpb$;
	   LOCATE 21, 2: PRINT scpd$;
	   LOCATE 22, 2: PRINT scpe$;
	END IF

	COLOR 7, 1
   RETURN



scpart:             ' subroutine print data & dimension = f(sc28%)
	LOCATE 5 + sc28%, 37
	FOR sc23% = 0 TO 3                                'print 4 * parameter or value text
	    PRINT "    ";
	    PRINT USING "######"; INT(scdiff * par%(can% + sc23%, parp%(sc28%, 1)));
	NEXT sc23%
	PRINT " "; dimen$                                     'scdiff: factor makes correct number base
  RETURN


scpop:              ' subroutine print text of modes
	COLOR 7, 1
	LOCATE 5 + sc28%, 38
	FOR sc23% = 0 TO 3                                'print 4 * parameter or value text
	    IF (scparapg% >= 2) THEN
	       scss3% = sc28%
	       scss4% = can% + sc23%
	       GOSUB curpg2
	       scsv3% = scss2% + scss1%                          'offset + parameter
	    ELSE
	       scsv3% = par%(can% + sc23%, parp%(sc28%, 1))
	       IF ((sc28% = 13) OR (sc28% = 14)) THEN
		  scsv3% = scsv3% AND 8
		  IF (scsv3% <> 0) THEN scsv3% = 1
	       ELSEIF ((sc28% = 15) AND (scsv3% > 11)) THEN scsv3% = 8     'K3 > 11
	       ELSEIF ((sc28% = 15) AND (scsv3% > 9)) THEN scsv3% = scsv3% - 4    'K3 > 9
	       ELSEIF (sc28% = 12) THEN
		scsv3% = scsv3% AND 3
		IF ((scsv3% AND 1) = 1) THEN scsv3% = 1                    'K2 = 0..2
	       END IF
	       scsv3% = scsv3% + parp%(sc28%, 4)
	    END IF
	    PRINT RIGHT$("    " + sctxt$(scsv3%), 10);
	NEXT sc23%
	PRINT " "; dimen$
  RETURN


scpaginc:           ' subr next page fkt key "pg -->"  level 2
   lin% = 6: row% = 39
   can% = 4 * INT(.25 * (scanreg% - 1)) + 1          ' calculate first channel
   IF (scparapg% >= 2) THEN
      scparapg% = 1
   ELSE
      scparapg% = 2
   END IF
   CLS                                                      ' new screen
   scparafl% = 0                                            ' new header
 RETURN

curleft:            ' move cursor left in param
			   ' change parameter, no interrupt
   scparatim! = TIMER      ' reset refresh timer
   GOSUB curclr                                   'clear last cursor position
   inpu$ = ""
   IF (scparapg% >= 1) THEN
      IF (row% <= 39) THEN
	  row% = 69
	  can% = 4 * INT(.25 * (scanreg% - 1)) + 4        ' calculate last channel
      ELSE
	  row% = row% - 10: can% = can% - 1
      END IF
   END IF                                         'test left end & shift left
   GOSUB curset                                   'set cursor position
   RETURN

curight:            ' move cursor right in param
			 ' change parameter, no interrupt
   scparatim! = TIMER      ' reset refresh timer
   GOSUB curclr                                   'clear last cursor position
   inpu$ = ""
   IF (scparapg% >= 1) THEN
      IF (row% >= 69) THEN
	 row% = 39
	 can% = 4 * INT(.25 * (scanreg% - 1)) + 1            ' calculate first channel of two controllers
      ELSE
	 row% = row% + 10: can% = can% + 1
      END IF
   END IF                                         'test right end & shift right
   GOSUB curset                                   'calculate parameter address from cursor position & set cursor
   RETURN

curclr:             'clear cursor for param
   padr% = 0                            'clr flg
   GOTO curse

curset:             'calculate parameter address & set cursor for param
   padr% = 1
   GOSUB curcalc                 'calculate addr in par%(,) from cursor position
   COLOR 8, 7                    'set color inverse
curse:
   IF (padr% = 0) THEN COLOR 7, 1     ' set back color : from curclr or addr not found
   LOCATE lin%, row%
   PRINT scpa$
   COLOR 7, 1
   RETURN


curcalc:           ' calculate addr in par%(,) from cursor position
   padr% = 0                            'default addr : cursor off
   IF (scparapg% >= 2) THEN             'page 2 select paramaters bitwise only
      scss3% = lin% - 5
      scss4% = can%
      GOSUB curpg2
      scsv3% = scss2% + scss1%                          'offset + parameter
      scpa$ = sctxt$(scsv3%)                            'text for flag
      padr% = 2
   ELSE                                 'page 1
      padr% = parp%(lin% - 5, 1)                        'except. K3 = 0-5,10,11,...
      scflgsv% = par%(can%, padr%)                      'except. K5,K6 = 0/8 -> 0/1
      IF ((lin% = 18) OR (lin% = 19)) THEN
	 scflgsv% = scflgsv% AND 8
	 IF (scflgsv% <> 0) THEN scflgsv% = 1
      ELSEIF ((lin% = 20) AND (scflgsv% > 11)) THEN scflgsv% = 8
      ELSEIF ((lin% = 20) AND (scflgsv% > 9)) THEN scflgsv% = scflgsv% - 4
      ELSEIF (lin% = 17) THEN
	 scflgsv% = scflgsv% AND 3
	 IF ((scflgsv% AND 1) = 1) THEN scflgsv% = 1  'except. K2 = 0..2
      END IF
      scsv3% = parp%(lin% - 5, 4) + scflgsv%            'offset + parameter
      scpa$ = sctxt$(scsv3%)                            'text
      IF ((lin% >= 6) AND (lin% < 16)) THEN             'number input --> text
	   scpa$ = RIGHT$("          " + STR$(par%(can%, padr%)), 8)
      END IF
   END IF
   RETURN



curpg2:            ' subr. calculate text of flags
      IF (scss3% = 1) THEN
	 scss2% = 20: scss1% = (par%(scss4%, 3) AND 1)
      ELSEIF (scss3% = 2) THEN scss2% = 1: scss1% = (par%(scss4%, 3) AND 2)
      ELSEIF (scss3% = 3) THEN scss2% = 2: scss1% = (par%(scss4%, 8) AND 2)
      ELSEIF (scss3% = 4) THEN scss2% = 22: scss1% = (par%(scss4%, 8) AND 1)
      ELSEIF (scss3% = 5) THEN scss2% = 24: scss1% = (par%(scss4%, 10) AND 8)
      END IF
      IF (scss1% <> 0) THEN scss1% = 1
  RETURN




bargraph:           'display bargraph for 8 channels
		    'subroutine f-key "bargr " level 1
	LOCATE 1, 2
	scrnd% = 4                                          'delta for incr/decr page
	ON KEY(6) GOSUB scanzinc                            '  "pg up"
	ON KEY(7) GOSUB scanzdec                            '  "pg dwn"
barg2:                                                  'loop until fkt ta "break"
	scaanreg% = 4 * INT(.25 * (scanreg% - 1)) + 1      ' calculate first channel of two controllers
	IF (scbarfl% <> 0) THEN GOTO barg4        ' first time:
	scbarfl% = 1                              '   display whole picture
	GOSUB graph                                         'basic display
barg4:                                            '   refresh values
	GOSUB timwx                                         'time & date & SP & X & SE
	GOSUB bar                                           'bar lines
	GOSUB scloop                            'cyclic dialog on interface bus set
	IF scflgk% <> 0 THEN GOTO barg2           'loop
	scbarfl% = 0
	COLOR 7, 1
   RETURN



graph:              'display coordinates & border & names
     CLS
     FOR bi% = 0 TO 7
	IF par%(scaanreg% + bi%, 27) <> 0 THEN              'parameters in channel  (nc > 0)
	  LOCATE 2, (2 + 10 * bi%)                          'channel names
	  PRINT nam$(scaanreg% + bi%)
	END IF
	LOCATE 3, (2 + 10 * bi%)                            'channel number all times
	PRINT " nr";
	PRINT USING "#####"; par%(bi% + scaanreg%, 1)
     NEXT bi%
     COLOR 7, 1
     FOR bk% = 2 TO 72 STEP 10
	  LOCATE 4, bk%                                     'border
	  PRINT "Ŀ"
	  FOR bi% = 5 TO 18
	     LOCATE bi%, bk%
	     PRINT "       "
	  NEXT bi%
	  LOCATE 19, bk%
	  PRINT ""
     NEXT bk%
     COLOR 7, 1
   
     FOR bk% = 5 TO 75 STEP 10                              'coordinates
	FOR bi% = 6 TO 18
	   LOCATE bi%, bk%
	   PRINT ""
	NEXT bi%                                            'scales
	LOCATE 12, bk% - 1
	PRINT "0  "
	LOCATE 5, bk% - 1
	PRINT "%  xw"
	LOCATE 6, bk% - 2
	PRINT "+6"
	LOCATE 9, bk% - 2
	PRINT "+3"
	LOCATE 15, bk% - 2
	PRINT "-3"
	LOCATE 18, bk% - 2
	PRINT "-6"
     NEXT bk%
  RETURN



timwx:      ' display date & time & process variable & setpoint & self tune & sensor error
   
    datum$ = DATE$
    IF (lingu% = 0) THEN
       datum$ = MID$(datum$, 4, 2) + "." + LEFT$(datum$, 2) + "." + RIGHT$(datum$, 4)
    END IF

    LOCATE 1, 55
    PRINT datum$                                             'date & time
    LOCATE 1, 73
    PRINT LEFT$(TIME$, 5)
    FOR bi% = 0 TO 7                              'next eight channels
	IF par%(scaanreg% + bi%, 27) = 0 THEN
	    LOCATE 2, 2 + 10 * bi%
	    PRINT "         ";
	    LOCATE 20, 2 + 10 * bi%
	    PRINT "         ";
	    LOCATE 21, 2 + 10 * bi%
	    PRINT "         ";
	    GOTO timwxend
	END IF
	LOCATE 2, (2 + 10 * bi%)                            'channel names
	PRINT nam$(scaanreg% + bi%)
	LOCATE 20, (3 + 10 * bi%)                           'parameters in channel  (nc > 0)
	PRINT "X  "; : PRINT USING "####"; par%(scaanreg% + bi%, 35); : PRINT "  ";
							    'process variable
	LOCATE 21, 3 + 10 * bi%
	PRINT "W  "; : PRINT USING "####"; par%(scaanreg% + bi%, 34); : PRINT "  ";
							    'setpoint
	LOCATE 23, 7 + 10 * bi%
	COLOR 10, 1
	scsv43% = par%(scaanreg% + bi%, 40)
	scsv44% = par%(scaanreg% + bi%, 41)
	IF (scsv43% AND 9) THEN
	   PRINT "SER ";                                    'bit 3/0=sensor error/cold junct.err
	ELSEIF (scsv44% AND 4) THEN PRINT "ALH ";           'alarm high?
	ELSEIF (scsv44% AND 8) THEN PRINT "ALL ";           'alarm low?
	ELSE PRINT "    ";                                  ' ok
	END IF
	COLOR 7, 1
timwxend:
    NEXT bi%
  RETURN



bar:                'calculate & display bargraph
  
    FOR bi% = 0 TO 7                              'next eight channels
	barstep% = .1 * (par%(scaanreg% + bi%, 35) - par%(scaanreg% + bi%, 34)) 'deviation xw in %
	IF (par%(scaanreg% + bi%, 27) <= 0) THEN barstep% = 0'no parameters
	IF barstep% > 6 THEN
						  ' 6..bar..
	    FOR bk% = 1 TO 6
		LOCATE 12 - bk%, 7 + 10 * bi%               'full bar up
		COLOR 4: PRINT "": COLOR 7
		LOCATE 12 + bk%, 7 + 10 * bi%               'clear bar down
		PRINT " "
	    NEXT bk%
      
	ELSEIF barstep% < -6 THEN
						  ' ..bar..-6
	    FOR bk% = 1 TO 6
		LOCATE 12 + bk%, 7 + 10 * bi%               'full bar down
		COLOR 4: PRINT "": COLOR 7
		LOCATE 12 - bk%, 7 + 10 * bi%               'clear bar up
		PRINT " "
	    NEXT bk%
	  
	ELSEIF barstep% < 0 THEN
						  ' -6..bar..0
	    bk% = barstep%
	    LOCATE 12 - bk%, 7 + 10 * bi%
	    COLOR 4: PRINT "": COLOR 7                     'half bar down

	    FOR bk% = (barstep% + 1) TO -1                  'full bar down
		LOCATE 12 - bk%, 7 + 10 * bi%
		COLOR 4: PRINT "": COLOR 7
	    NEXT bk%
     
	    FOR bk% = -6 TO (barstep% - 1)                  'clear bar up
		LOCATE 12 - bk%, 7 + 10 * bi%
		PRINT " "
	    NEXT bk%
	    FOR bk% = 1 TO 6
		LOCATE 12 - bk%, 7 + 10 * bi%
		PRINT " "
	    NEXT bk%

	ELSEIF barstep% > 0 THEN
						  '0..bar..6
	    FOR bk% = 1 TO (barstep% - 1)                   'full bar up
		LOCATE 12 - bk%, 7 + 10 * bi%
		COLOR 4: PRINT ""
	    NEXT bk%
	     
	    LOCATE 12 - barstep%, 7 + 10 * bi%
	    COLOR 4: PRINT "": COLOR 7                     'half bar up
	    FOR bk% = (barstep% + 1) TO 6
		LOCATE 12 - bk%, 7 + 10 * bi%
		PRINT " "
	    NEXT bk%

	    FOR bk% = -6 TO -1
		LOCATE 12 - bk%, 7 + 10 * bi%               'clear bar down
		PRINT " "
	    NEXT bk%
	END IF
						  ' set half bar
	LOCATE 12, 7 + 10 * bi%
	IF barstep% > 0 THEN
		COLOR 4: PRINT "": COLOR 7                 'bar upper half
	ELSEIF barstep% < 0 THEN
		COLOR 4: PRINT "": COLOR 7                 'bar lower half
	ELSE
		FOR bk% = -6 TO -1                          'clear bar down
		     LOCATE 12 - bk%, 7 + 10 * bi%
		     PRINT " "
		NEXT bk%
	       
		FOR bk% = 1 TO 6
		     LOCATE 12 - bk%, 7 + 10 * bi%          'clear bar up
		     PRINT " "
		NEXT bk%

		LOCATE 12, 7 + 10 * bi%
		COLOR 10: PRINT "": COLOR 7
	END IF
    NEXT bi%
  RETURN




rdfil:              'function key "rd fil" level 1
  CLS               ' read a file with parameters & names for one controller modul (4 chan.) from source
					 'are you shure, ask filename
  LOCATE 3, 2
  set$ = "  zone  "
  IF (lingu% = 0) THEN                            'ask again
      PRINT "          Die Parameter bis Regelkreis     werden ueberschrieben"
      LOCATE 3, 39: PRINT scnmax%
      INPUT "           durch  file.par .                        (j/n) :   ", in$
      IF ((in$ <> "j") AND (in$ <> "J") AND (in$ <> "y") AND (in$ <> "Y")) THEN GOTO rdfil9
rdfil1:
      inpnr% = 1                                            'default number = 1
      PRINT : PRINT
      INPUT "          Pfad/Filename eingeben             (ohne  .par) :   ", inpu$
      PRINT : PRINT                                         'parameter to bus
      INPUT "          Parameter an Regelmodule ausgeben?        (j/n) :   ", inn$

  ELSE
      PRINT "          parameters until controller      will be destroyed"
      LOCATE 3, 39: PRINT scnmax%
      INPUT "           and loaded from   file.par .          (y/n) :   ", in$
      IF ((in$ <> "j") AND (in$ <> "J") AND (in$ <> "y") AND (in$ <> "Y")) THEN GOTO rdfil9
rdfil2:
      inpnr% = 1                                            'default number = 1
      PRINT : PRINT
      INPUT "          type path/filename              (without .par) :   ", inpu$
      PRINT : PRINT
      INPUT "          transmit parameters to controller moduls (y/n) :   ", inn$
  END IF

  IF ((inn$ <> "j") AND (inn$ <> "J") AND (inn$ <> "y") AND (inn$ <> "Y")) THEN inn$ = ""
  IF (inpu$ = "") THEN inpu$ = "data.par" ELSE inpu$ = inpu$ + ".par"
  CLOSE #5: OPEN inpu$ FOR INPUT AS #5 LEN = 4000
  
    FOR sc31% = 1 TO scnmax%
       LINE INPUT #5, pa$
'       LOCATE 19, 2: PRINT pa$;
       GOSUB rdsub
    NEXT sc31%
    CLOSE #5
rdfil9:
    CLS
    GOSUB keyset
    scflgk% = 0: losch% = 0
    GOSUB fkey9sub
  RETURN



rdsub:              'read name  & parameters for one channel; delete values; set flag
   
    pa$ = MID$(pa$, 2, LEN(pa$) - 2)                      'line input adds '"' two times
    in$ = LEFT$(pa$, 11)
    LOCATE 18, 20: PRINT " name :"; in$;
    in$ = MID$(pa$, 12, 6)
    in% = VAL(in$)
'    LOCATE 18, 40: PRINT " nr :"; ; in%;
    IF ((in% < 1) OR (in% > 32)) THEN                     'test channel number
	par%(sc31%, 1) = sc31%                          'set default
    ELSE
	par%(sc31%, 1) = in%
    END IF
    IF (lingu% = 0) THEN
	  LOCATE 16, 2
	  PRINT "                             lese Regelkreis              :   "; sc31%
    ELSE
	  LOCATE 16, 2
	  PRINT "                            reading channel            :   "; sc31%
    END IF
    LOCATE 19, 2
    FOR sc32% = 3 TO 35
	 in% = VAL(MID$(pa$, 6 * sc32%, 6))
	 par%(sc31%, sc32% - 1) = in%                   'set parameters
'         PRINT in%;                                      ' without numbers: exchange param. of
    NEXT sc32%                                            '                  modules possible
    IF (inn$ = "") THEN
	par%(sc31%, 79) = 68                            'set "D" flag
    ELSE
	par%(sc31%, 79) = 65                            'set "A" flag, loaded parameters will be
    END IF                                                '   written to controllers !!!!!!!!!

    IF (par%(sc31%, 27) > 0) THEN GOTO rdfil4             'no parameters ?
    nam$(sc31%) = RIGHT$(set$ + HEX$(sc31%), 8)           'set new dummy names
rdfil4:
    FOR sc32% = 35 TO 78
	par%(sc31%, sc32%) = 0                    'clear values
    NEXT sc32%
   
    timstop! = TIMER + .3
    WHILE (TIMER <= timstop!)                           'delay for next bloc 0.3 sec
    WEND
  RETURN



wrfil:              'function key "wr fil" level 1
  CLS               ' write a file with parameters & names of all 8 controller moduls (4 chan.each) into source
				 'are you shure, ask filename
  LOCATE 3, 2
  set$ = "  zone  "

  IF (lingu% = 0) THEN                            'ask again
      PRINT "          Die Parameter aller Regelmodule werden gespeichert,"
      INPUT "           es wird ein   file.par erzeugt.        (j/n) :   ", in$
      IF ((in$ <> "j") AND (in$ <> "J") AND (in$ <> "y") AND (in$ <> "Y")) THEN GOTO wrfil9
      GOSUB dataset
wrfil1:
      LOCATE 12, 2
      INPUT "          Pfad/Filename eingeben           (ohne  .par) :   ", inpu$

  ELSE
      PRINT "          parameters of all controllers are written"
      INPUT "           into  file.par                         (y/n) :   ", in$
      IF ((in$ <> "j") AND (in$ <> "J") AND (in$ <> "y") AND (in$ <> "Y")) THEN GOTO wrfil9
      GOSUB dataset
wrfil2:
      LOCATE 12, 2
      INPUT "          type path/filename             (without .par) :   ", inpu$
  END IF                                                    'default path on c:/

  IF (inpu$ = "") THEN inpu$ = "data.par" ELSE inpu$ = inpu$ + ".par"
  CLOSE #5: OPEN inpu$ FOR OUTPUT AS #5 LEN = 4000
 
  FOR sc31% = 1 TO 32
      GOSUB wrsub
      WRITE #5, pa$
'      LOCATE 20, 2: PRINT pa$;
  NEXT sc31%
wrfil9:
  CLOSE #5
    CLS
    GOSUB keyset
    scflgk% = 0: losch% = 0
    GOSUB fkey9sub
  RETURN


wrsub:              'save name & parameters for one channel

    in$ = nam$(sc31%)                                       'write name
    IF (in$ = "") THEN in$ = set$ + HEX$(sc31%)
    pa$ = RIGHT$("          " + in$, 11)
    LOCATE 20, 20: PRINT " name :"; in$;
    in% = par%(sc31%, 1)
    IF ((in% < 1) OR (in% > 32)) THEN                       'test channel number
	par%(sc31%, 1) = sc31%                              'set default
	in% = sc31%
    END IF                                                  'write channel number
    pa$ = pa$ + RIGHT$("       " + STR$(in%), 6)
    LOCATE 20, 40: PRINT " nr :"; in%;
    IF (lingu% = 0) THEN
	  LOCATE 16, 2
	  PRINT "                               speichere Regelkreis     :   "; sc31%
    ELSE
	  LOCATE 16, 2
	  PRINT "                              writing channel     :   "; sc31%
    END IF
    LOCATE 19, 2
    FOR sc32% = 3 TO 35
	in% = par%(sc31%, sc32% - 1)
	pa$ = pa$ + RIGHT$("       " + STR$(in%), 6)
    NEXT sc32%
    timstop! = TIMER + .3
    WHILE (TIMER <= timstop!)                           'delay for next bloc 0.3 sec
    WEND
  RETURN



names:              'config - change channel numbers and/or names
   CLS              'subroutine f-key "config" level 1
   COLOR 7, 1
   scflgk% = 0
   scconfl% = 1                                   ' loop until ready
   scparapg% = 0                                  ' move cursor for names
   KEY OFF                                        ' set keys
   KEY 1, "": KEY 2, "": KEY 3, "": KEY 4, ""
   KEY 5, "": KEY 7, "": KEY 8, "": KEY 10, ""
   KEY(1) OFF: KEY(2) OFF: KEY(3) OFF: KEY(4) OFF: KEY(5) OFF
   KEY(6) ON: KEY(7) OFF: KEY(8) OFF: KEY(9) ON: KEY(10) OFF
   KEY(11) ON: KEY(12) OFF: KEY(13) OFF: KEY(14) ON         'set cursor keys
 
   pa% = 0                                        'set page 1
   can% = 16 * pa% + 1                            'set first channel on display
   lin% = 2                                       'set cursor first line
   row% = 45                                      'set cursor second row
   GOSUB namset                         'set display with up to 4 controllers

names4:             'set fkt key loops, level 2
     ON KEY(6) GOSUB pgnext                       'next page
'     ON KEY(9) GOSUB scfl9                       'end of configuration
     ON KEY(11) GOSUB curup                       'cursor up
     ON KEY(14) GOSUB curdwn                      'cursor down
    
names5:                                           'test input
     GOSUB curdis                                 'display cursor
     inpu$ = ""                                   'clr input buffer
names6:

     ino$ = INKEY$
					       'change ?
     IF ((LEN(ino$) = 2)) THEN
	IF (ASC(LEFT$(ino$, 1)) = 0) THEN
	ino$ = RIGHT$(ino$, 1)                               'check first cursor bloc
	IF (ino$ = "H") THEN
	   GOSUB curup                                       'cursor up
	ELSEIF (ino$ = "P") THEN GOSUB curdwn                'cursor down
	END IF
	ino$ = ""                                            'clr input buffer
	END IF
     END IF


     IF (ino$ = "") THEN GOTO names8                         'wait
     IF (ino$ <> CHR$(13)) THEN
	COLOR 8, 7
	inpu$ = inpu$ + ino$                                 'input
	LOCATE lin%, row%                                    'display input
	PRINT RIGHT$("        " + inpu$, 8);
	timstop! = TIMER + .5
	WHILE (TIMER <= timstop!)                           'delay for next key 0.5 sec
	WEND
	COLOR 7, 1
	GOTO names6
     ELSE                                                 'cr
	IF (inpu$ = "") THEN GOTO names7          'cursor down without change
	    nam$(can%) = RIGHT$("        " + inpu$, 8)      'name
	timstop! = TIMER + .1
	WHILE (TIMER <= timstop!)                           'delay for display 0.1 sec
	WEND
	par%(can%, 27) = 0                                  ' clr tc (2.test for parameter)
	par%(can%, 79) = 0                                  ' clr "D" flg

	inpu$ = "": inpu% = 0
     END IF
names7:
     GOSUB curdis                                           'display input
'     timstop! = TIMER + .2
'     WHILE (TIMER <= timstop!)                           'delay for display 0.1 sec
'     WEND
     GOSUB curout                                           'display off
     GOSUB curdwn
     GOTO names5                                            'loop
names8:
     IF (scconfl% <> 0) THEN GOTO names6          'exit or loop
    
     scflgk% = 0                                            'level 2-->1
     scxfl% = 0                                             'clear refresh - flag
     COLOR 7, 1                                             'reset color
     GOSUB keyset                                           'set fkeys level 1
  RETURN



namset:             'set display with up to 4 controllers
   IF (lingu% = 0) THEN GOTO namset2            'goto config in deutsch
     KEY 6, "chan +": KEY 9, "break"
     KEY ON
     FOR sck% = 0 TO 3
	IF (16 * pa% + 1 + 4 * sck% > cmax%) THEN GOTO namset9

	PRINT "     controller modul :"; 4 * pa% + 1 + sck%
	PRINT "               channel:  ";
	PRINT USING "#####"; par%(1 + 4 * sck% + 16 * pa%, 1)
	LOCATE 2 + 6 * sck%, 39
	PRINT "name: "; nam$(1 + 4 * sck% + 16 * pa%)
	PRINT "               channel:  ";
	PRINT USING "#####"; par%(2 + 4 * sck% + 16 * pa%, 1)
	LOCATE 3 + 6 * sck%, 39
	PRINT "name: "; nam$(2 + 4 * sck% + 16 * pa%)
	PRINT "               channel:  ";
	PRINT USING "#####"; par%(3 + 4 * sck% + 16 * pa%, 1)
	LOCATE 4 + 6 * sck%, 39
	PRINT "name: "; nam$(3 + 4 * sck% + 16 * pa%)
	PRINT "               channel:  ";
	PRINT USING "#####"; par%(4 + 4 * sck% + 16 * pa%, 1)
	LOCATE 5 + 6 * sck%, 39
	PRINT "name: "; nam$(4 + 4 * sck% + 16 * pa%);
	IF (sck% < 3) THEN PRINT : PRINT
     NEXT sck%
     GOTO namset9
namset2:                                           'config in deutsch
     KEY 6, " nr +": KEY 9, "zurck"
     KEY ON
     FOR sck% = 0 TO 3
	IF (16 * pa% + 1 + 4 * sck% > cmax%) THEN GOTO namset9

	PRINT "     Regelmodul       :"; 4 * pa% + 1 + sck%
	PRINT "            Regelkreis:  ";
	PRINT USING "#####"; par%(1 + 4 * sck% + 16 * pa%, 1)
	LOCATE 2 + 6 * sck%, 39
	PRINT "name: "; nam$(1 + 4 * sck% + 16 * pa%)
	PRINT "            Regelkreis:  ";
	PRINT USING "#####"; par%(2 + 4 * sck% + 16 * pa%, 1)
	LOCATE 3 + 6 * sck%, 39
	PRINT "name: "; nam$(2 + 4 * sck% + 16 * pa%)
	PRINT "            Regelkreis:  ";
	PRINT USING "#####"; par%(3 + 4 * sck% + 16 * pa%, 1)
	LOCATE 4 + 6 * sck%, 39
	PRINT "name: "; nam$(3 + 4 * sck% + 16 * pa%)
	PRINT "            Regelkreis:  ";
	PRINT USING "#####"; par%(4 + 4 * sck% + 16 * pa%, 1)
	LOCATE 5 + 6 * sck%, 39
	PRINT "name: "; nam$(4 + 4 * sck% + 16 * pa%);
	IF (sck% < 3) THEN PRINT : PRINT
     NEXT sck%
namset9:
  RETURN



pgnext:             ' increment page counter
   CLS
   COLOR 7, 1                                     'default color
   inpu$ = ""                                     'clr input buffer
	pa% = pa% + 1                             'pa% = page counter
	IF ((pa% > 7) OR (16 * pa% >= cmax%)) THEN
	       pa% = 0
	END IF
	can% = 16 * pa% + 1                       'set first channel on display
	lin% = 2                                  'set cursor second line
	row% = 45                                 'set cursor second row
	GOSUB namset                              'set new display
	GOSUB curdis                              'display cursor
   RETURN



ready:              'end of configuration names
     inpu$ = ""                                             'clear string
     RETURN



curup:              'cursor step up
   inpu$ = ""                                     'clr input buffer
   IF (scparapg% = 1) THEN
       scparatim! = TIMER                         ' reset refresh timer
       GOSUB curclr                               'clear last cursor position
       IF (lin% <= 7) THEN
	   lin% = 6                               'parma: page 1
       ELSEIF (lin% = 17) THEN lin% = 15          ' free line
       ELSE lin% = lin% - 1
       END IF
       GOSUB curset
   ELSEIF (scparapg% = 2) THEN
       scparatim! = TIMER                         ' reset refresh timer
       GOSUB curclr                               'clear last cursor position
       IF (lin% <= 7) THEN lin% = 6 ELSE lin% = lin% - 1
       GOSUB curset                               'param: page 2
   ELSE
      GOSUB curout                                'clear last cursor position
	IF (lin% <= 2) THEN                       'config
	    lin% = 2
	    can% = 16 * pa% + 1                   'set last channel on display
	ELSEIF ((lin% = 8) OR (lin% = 14) OR (lin% = 20)) THEN
	    lin% = lin% - 3
	    can% = can% - 1
	ELSE
	    lin% = lin% - 1
	    can% = can% - 1
	END IF
      GOSUB curdis                              'display cursor
   END IF
  RETURN



curdwn:             'cursor step down
   inpu$ = ""                                     'clr input buffer
   IF (scparapg% = 1) THEN
       scparatim! = TIMER                         ' reset refresh timer
       GOSUB curclr                               'clear last cursor position
       IF (lin% >= 20) THEN
	   lin% = 6                               'param: page 1
       ELSEIF (lin% = 15) THEN lin% = 17          ' free line
       ELSE lin% = lin% + 1
       END IF
       GOSUB curset
   ELSEIF (scparapg% = 2) THEN
       scparatim! = TIMER                         ' reset refresh timer
       GOSUB curclr                               'clear last cursor position
       IF (lin% >= 10) THEN lin% = 6 ELSE lin% = lin% + 1
       GOSUB curset                               'param: page 2
   ELSE
      GOSUB curout                                'clear last cursor position
      IF (can% >= cmax%) THEN lin% = 24           'test last channel
      IF (lin% >= 23) THEN                        'config:
	    lin% = 2
	    can% = 16 * pa% + 1                   'set first channel on display
      ELSEIF ((lin% = 5) OR (lin% = 11) OR (lin% = 17)) THEN
	    lin% = lin% + 3
	    can% = can% + 1
      ELSE
	    lin% = lin% + 1
	    can% = can% + 1
      END IF
      GOSUB curdis                                'display cursor
   END IF
  RETURN



curdis:             'display cursor
   COLOR 8, 7
   GOTO curdi

curout:             'clear cursor display
   COLOR 7, 1
curdi:
   LOCATE lin%, row%
      PRINT RIGHT$("         " + nam$(can%), 8);
   COLOR 7, 1
   RETURN


lingua:         'select language for  dialog
     lingua2                                              'set big letters

lingua4:
     LOCATE 17, 40
     PRINT "      ";
     LOCATE 17, 40
     ii$ = INKEY$
     IF (ii$ = "") THEN GOTO lingua4                      'wait until input
     IF ((ii$ = "d") OR (ii$ = "D")) THEN
	lingu% = 0
     ELSEIF ((ii$ = "e") OR (ii$ = "E")) THEN
	lingu% = 1
     ELSE
	GOTO lingua4                                      'select lingua deutsch or english
     END IF

     PRINT ii$;

     timstop! = TIMER + 2
     WHILE (TIMER <= timstop!)                              'delay for next bloc 0.5 sec
     WEND
     COLOR 7, 1
  RETURN



paraset:            'set table with address in par$/parametertype
 
					'default
    FOR ssi% = 1 TO 18
      parp%(ssi%, 1) = 0: parp%(ssi%, 2) = 4: parp%(ssi%, 3) = 4095
			  parp%(ssi%, 4) = 1: parp%(ssi%, 5) = 0
    NEXT ssi%
					'par.%(,) = parp%(,)
					'par.%(x, ) = line number from 6 up
					'par.%( ,1) = parameter number in par$(),par%(,);  0 = empty line
					'par.%( ,2) = number of channels: 4 or 1 = common
					'par.%( ,3) = upper limit for parameter 0/1/4/...
					'par.%( ,4) = offset in sctxt$() + 1
					'par.%( ,5) = lower limit for parameters

    parp%(1, 1) = 34: parp%(2, 1) = 18
    parp%(3, 1) = 32: parp%(4, 1) = 33
    parp%(5, 1) = 13: parp%(6, 1) = 14: parp%(7, 1) = 15: parp%(8, 1) = 16
    parp%(9, 1) = 17: parp%(10, 1) = 27: parp%(10, 5) = 1: parp%(10, 3) = 100
    parp%(12, 1) = 5: parp%(12, 3) = 2: parp%(12, 4) = 15
    parp%(13, 1) = 9: parp%(13, 3) = 1: parp%(13, 4) = 4
    parp%(14, 1) = 8: parp%(14, 3) = 1: parp%(14, 4) = 2
    parp%(15, 1) = 6: parp%(15, 3) = 8: parp%(15, 4) = 6
    parp%(17, 1) = 79: parp%(17, 3) = 99
  RETURN




tablec:
		'table with comment to parameters and values set
		' place "n" in array par$(n) is the same as in par%( ,n)

IF (lingu% = 0) THEN GOTO tablec2                 'goto table in deutsch
	       
		'table in english
				      'set default channel names
	FOR sci1% = 1 TO cmax%                    ' for bargraph
	   nam$(sci1%) = RIGHT$("  zone  " + HEX$(sci1%), 8)
	NEXT sci1%

sctxt$(1) = "   on    "        'set text table for param. flags
sctxt$(2) = "  off    "
sctxt$(3) = "   on    "
sctxt$(4) = " heat    "
sctxt$(5) = " ht/cool "
sctxt$(6) = " type L  "
sctxt$(7) = " type J  "
sctxt$(8) = " type K  "
sctxt$(9) = "  ...    "
sctxt$(10) = " RTD 4wr "
sctxt$(11) = " RTD 2wr "
sctxt$(12) = " linear  "
sctxt$(13) = " lin4-20 "
sctxt$(14) = " special "
sctxt$(15) = " control "
sctxt$(16) = "   off   "
sctxt$(17) = " measure "
sctxt$(18) = " normal  "
sctxt$(19) = " ERROR   "
sctxt$(20) = " enable  "
sctxt$(21) = " disable "
sctxt$(22) = " short   "
sctxt$(23) = " long    "
sctxt$(24) = "  C     "
sctxt$(25) = "  F     "
	      

		  ' signed integer parameters   30 tabs comment

		  ' n = 1..44 number of parameters and values in array par%(No,n)
		  'No = 1..max, channel number
		  ' - = not used
		  ' + = used in some combinations
						    ' y/n means bit = 0 / <>0

		'unsigned char parameters 6 bit
par$(1) = "channel                 No    "                 'No = logical number of channel
par$(2) = "                              "                 'guided flags for EXW
par$(3) = "struct. scan, pro, opt  K0    "
par$(4) = "struct. controller mode K1    "
par$(5) = "controller mode         K2    "
par$(6) = "input linearization     K3    "
par$(7) = "struct. alarm           K4    "
par$(8) = "limit comparator        K5    "
par$(9) = "controller type         K6    "
par$(10) = "struct. input/limits    K7    "
par$(11) = "struct. linear output   K8    "
par$(12) = "struct. controller type K9    "
		' unsigned integer parameters 12 bit (2*6 bit)
par$(13) = "controller gain         H0    "
par$(14) = "prop.band I/II          H1    "
par$(15) = "deadband/ alarm 3       H2    "
par$(16) = "delay time Tu           H3    "
par$(17) = "compensation time Tg    H4    "
par$(18) = "setpoint for exchange   H5    "
par$(19) = "range factor            H6    "
par$(20) = "                        H7    "
par$(21) = "                        H8    "
par$(22) = "                        H9    "
par$(23) = "startup limit AFS2      G0    "
par$(24) = "                        G1    "
par$(25) = "output factor           G2    "
par$(26) = "output                  G3    "
par$(27) = "cycle time              G4    "
par$(28) = "output source           G5    "
par$(29) = "                        G6    "
par$(30) = "                        G7    "
par$(31) = "setpoint limit high     G8    "
par$(32) = "alarm low               L-    "
par$(33) = "alarm high              L+    "
par$(34) = "setpoint active         W     "
		' unsigned integer values 12 bit (2*6 bit)
par$(35) = "process variable        X     "                ' X  (oC, oF, units), unsigned
par$(36) = "process variable .25 d  E8    "                ' X (.25 digit)
par$(37) = "output                  y     "                ' Y = ton/(ton+toff) * 0x8000 or 100'D
par$(38) = "                        E0    "
par$(39) = "clock                   E2    "                'time = 0..63'D; unit= 0.4sec*G4
par$(40) = "sensor error            E3    "                'bit 3,0 = sensor error/cold junct. err.
par$(41) = "status outputs          E4    "                'bit 3..0 = output L-/L+/1.SP/2.SP
par$(42) = "                        E5    "                'software rev. number from >1.70
par$(43) = "                        E7    "

par$(79) = "status array par%( , )        "                ' 0,"?","A","D" means no parameter pa,ask for pa.,changed pa.,pa. o.k.
GOTO tablec4

tablec2:
				      'set default channel names
	FOR sci1% = 1 TO cmax%                   ' for bargraph
	   nam$(sci1%) = RIGHT$("  zone  " + HEX$(sci1%), 8)
	NEXT sci1%

sctxt$(1) = "  ein    "        'set text table for param. flags
sctxt$(2) = "  aus    "
sctxt$(3) = "  ein    "
sctxt$(4) = " 2-Punkt "
sctxt$(5) = " 3-Punkt "
sctxt$(6) = " Typ L   "
sctxt$(7) = " Typ J   "
sctxt$(8) = " Typ K   "
sctxt$(9) = "  ...    "
sctxt$(10) = " Pt100 4d"
sctxt$(11) = " Pt100 2d"
sctxt$(12) = " linear  "
sctxt$(13) = " lin4-20 "
sctxt$(14) = " spezlin "
sctxt$(15) = " Regler  "
sctxt$(16) = "   aus   "
sctxt$(17) = " messen  "
sctxt$(18) = " normal  "
sctxt$(19) = " FEHLER  "
sctxt$(20) = " frei    "
sctxt$(21) = " sperren "
sctxt$(22) = " kurz    "
sctxt$(23) = " lang    "
sctxt$(24) = "  C     "
sctxt$(25) = "  F     "

	       
		' signed integer parameters   30 tabs comment
par$(1) = "Regelkreisnummer        No    "                 'No = logical number of channel
par$(2) = "                              "                 'guided flags for EXW
par$(3) = "Strukt. scan, pro, opt  K0    "
par$(4) = "Strukt. Regler mode     K1    "
par$(5) = "Reglermodus             K2    "
par$(6) = "Eingang Linearisierung  K3    "
par$(7) = "Strukt.Grenzsignalgeber K4    "
par$(8) = "Grenzsignalgeber        K5    "
par$(9) = "Reglertyp               K6    "
par$(10) = "Strukt. Eingang/Grenzs. K7    "
par$(11) = "struct. Linearausgang   K8    "
par$(12) = "struct. Reglertyp       K9    "
		' unsigned integer parameters 12 bit (2*6 bit)
par$(13) = "Reglerverstrkung       H0    "
par$(14) = "Reglerverst. 1.SP/2.SP  H1    "
par$(15) = "Totzone/ 3.Grenzwert    H2    "
par$(16) = "Verzugszeit Tu          H3    "
par$(17) = "Ausgleichszeit Tg       H4    "
par$(18) = "Tauschsollwert          H5    "
par$(19) = "Messbereichsfaktor      H6    "
par$(20) = "                        H7    "
par$(21) = "                        H8    "
par$(22) = "                        H9    "
par$(23) = "Grenze Anfahr. AFS2     G0    "
par$(24) = "                        G1    "
par$(25) = "Ausgangsfaktor          G2    "
par$(26) = "Stellgrad Hand          G3    "
par$(27) = "Systemabtastzeit        G4    "
par$(28) = "output source           G5    "
par$(29) = "                        G6    "
par$(30) = "                        G7    "
par$(31) = "Sollgrenzwert oben      G8    "
par$(32) = "Grenzwert unten         L-    "
par$(33) = "Grenzwert oben          L+    "
par$(34) = "Sollwert aktiv          W     "
		' unsigned integer values 12 bit (2*6 bit)
par$(35) = "Regelgrsse             X     "                ' X  (oC, oF, units), unsigned
par$(36) = "Regelgrsse 0.25 digit  E8    "
par$(37) = "Stellgrad               Y     "                ' Y = ton/(ton+toff) * 0x8000 or 100'D
par$(38) = "                        E0    "
par$(39) = "Uhr                     E2    "                'time = 0..63'D; unit= 0.4sec*G4
par$(40) = "Fhlerfehler            E3    "                'bit 3,0 = sensor error/cold junct. err.
par$(41) = "Schaltausgnge          E4    "                'bit 3..0 = output L-/L+/1.SP/2.SP
par$(42) = "                        E5    "                'software rev. number from >1.70
par$(43) = "                        E7    "

par$(79) = "status feld par%( , )         "                ' 0,"?","A","D" = keine parameter pa,frage nach pa.,gend.pa.,pa. i.O

tablec4:
  RETURN

  END

SUB examples



'example 1: ask for new values of channels
'
'  all controllers will be asked automatically by interrupt programm scloop
'


'example 2: ask for new parameters of channel 7 from interface
'
'  line-number sc22% of arrays par$() and par%(,sc22%) may be different from channel number par%( ,1) !!!
'
'      scnreg% =  7                                ' set line-number (equal channel-number for this case)
'      par%(scnreg%,79) = 63                       ' set "?" - flag
'                                                  ' thats all, because interrupt routine scloop test flags automatically


'example 3: change parameter(s)  of channel 19
'
'  While changing parameters via interface and controller keys at the same time last input will be valid, so
'  its a good practice asking for new parameters before changing and output the changed parameters.
'  Are only some controllers on interface-bus, the automatic parameter input will be fast enough.
'  Because the interrupt distance sczeit% =1sec (XT: =2sec), the parameter input time with 5 controller
'   modules is    sczeit% * 4 * 3 *(5 + 1) sec.
'
'      scnreg% = 19
'      par%(scnreg%,79) = 63                       '"?" flag; ask for new parameters; 8 channels will
'                                                  '    be testet for this flag on each sczeit%
'
'      job                                         'job or wait at min.  sczeit% * (max.channel number/8 +1)sec
'
'      scopreg% = 19
'      par%(scopreg%,34)  = par%(scopreg%,34) + 5  'increment active setpoint by 5
'      par%(scopreg%,33) = 15                      'set alarm high at 15 relative setpoint
'      par%(scopreg%,27) = 3                       'set output cycle time at 1.2 sec
'
'      par%(scopreg%,79) = 65                      '"A" flag; output parameters to interface bus
'
'
'      sc33% = 4*INT((scopreg%-1)/4) + 1           'first channel of a controller module
'
'      par%(scopreg%,5) = 0                        'set outputs on
'
'      par%(scopreg%,79) = 65                      'Because common parameters for this 4 channels are the same
'                                                  ' the output of one of them to interface-bus will do the job.
'
'      job                                         'job or wait at min.  sczeit% * (max.channel number/8 +1)sec
'



END SUB

SUB lingua2       'select language for  dialog
     CLS
     COLOR 10, 1
     LOCATE 8, 4
     PRINT " ķ ";                                       'print question
     LOCATE 9, 4
     PRINT "     ";
     LOCATE 10, 4
     PRINT " Ľ ";
     LOCATE 8, 46
     PRINT "  ";
     LOCATE 9, 46
     PRINT "    ";
     LOCATE 10, 46
     PRINT "  ";
     COLOR 7, 1
     LOCATE 9, 41
     PRINT "OR"
     LOCATE 8, 11
     PRINT "           ";
     LOCATE 9, 11
     PRINT "         ķ    ͹ ";
     LOCATE 10, 11
     PRINT "     Ľ     ";
     LOCATE 8, 50
     PRINT " ֿ ķ         ";
     LOCATE 9, 50
     PRINT "   ķ     ķ ͹ ";
     LOCATE 10, 50
     PRINT "  Ľ   Ľ    ";
     COLOR 7, 1
     LOCATE 17, 25
     PRINT " input :      ";
END SUB

SUB logo
logo:               'company & order no.
     COLOR 4, 1, 1
     SCREEN 0
     CLS
     PRINT
     PRINT "                                        "
     PRINT "                                    "
     PRINT "                                "
     PRINT "                                "
     PRINT "                                "
     PRINT "                                  "
     PRINT "                            "
     PRINT "                        "
     PRINT "                      "
     PRINT "                    "
     PRINT "                            "
     PRINT "                              "
     PRINT
     PRINT
     PRINT "        ͻ ͻ  ͻ   ɻ  ɻ  ͻ    ֿ   ɻ  ͻ    ɻ  "
     PRINT "        ͹ ͻ   ͹   ׽ ׽         ׽       ׽ "
     PRINT "          ͼ      ͼ   ͼ ͼ    ͼ ͼ ͼ    "
     COLOR 15, 1
     PRINT "                          M e t r a w a t t   G m b H "
     COLOR 7, 1
     PRINT
     PRINT
     PRINT "        DEMO - Programm  sc9000     V  1.2"
     PRINT "        R 9000 Schnittstelle zu PC        "
     PRINT "                                                      Best. Nr.:  GTZ4802";

     timstop! = TIMER + 5                                     'pcdel% not def. yet
     WHILE (TIMER <= timstop!)                              'delay for display 5 sec
     WEND
     COLOR 7, 1
END SUB

